/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class BlockStoneAnvil
extends BlockRockVariant {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockStoneAnvil(Rock.Type type, Rock rock) {
        super(type, rock);
        FallingBlockManager.Specification spec = new FallingBlockManager.Specification(type.getFallingSpecification());
        FallingBlockManager.registerFallable(this, spec);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEAnvilTFC te = Helpers.getTE((IBlockAccess)worldIn, pos, TEAnvilTFC.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        TEAnvilTFC te = Helpers.getTE((IBlockAccess)worldIn, pos, TEAnvilTFC.class);
        if (te == null) {
            return false;
        }
        IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (cap == null) {
            return false;
        }
        if (playerIn.func_70093_af()) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_190926_b()) {
                for (int i = 0; i < 2; ++i) {
                    ItemStack stack = cap.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    ItemStack result = cap.extractItem(i, 1, false);
                    playerIn.func_184611_a(hand, result);
                    return true;
                }
            } else if (te.isItemValid(2, heldItem)) {
                if (!worldIn.field_72995_K && te.attemptWelding(playerIn)) {
                    worldIn.func_184133_a(null, pos, TFCSounds.ANVIL_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (i == 2 || !te.isItemValid(i, heldItem) || te.getSlotLimit(i) <= cap.getStackInSlot(i).func_190916_E()) continue;
                    ItemStack result = cap.insertItem(i, heldItem, false);
                    playerIn.func_184611_a(hand, result);
                    TerraFirmaCraft.getLog().info("Inserted {} into slot {}", (Object)heldItem.func_82833_r(), (Object)i);
                    return true;
                }
            }
        } else {
            if (!worldIn.field_72995_K) {
                TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.ANVIL);
            }
            return true;
        }
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEAnvilTFC();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)BlockRockRaw.get(this.rock, Rock.Type.RAW));
    }

    @Override
    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRock.get(this.rock);
    }
}

